#include "voice-connection.h"

bool VoiceConnection::connectToVoiceChannel(dpp::message_create_t event)
{
        dpp::guild *g = dpp::find_guild(event.msg.guild_id);
        if (!g->connect_member_voice(event.msg.author.id, false, true))
        {
            return false;
        }
        return true;
}

bool VoiceConnection::connectToVoiceBlocking(dpp::cluster &bot, dpp::message_create_t event)
{
        if(connectToVoiceChannel(event) == false)
        {
            return false;
        }
        //Register on_voice_ready event to then directly play audio after joining the voice channel
        std::promise<bool> promise;
        std::shared_future<bool> future = promise.get_future();
        dpp::event_handle eventId = bot.on_voice_ready([&promise, event](const dpp::voice_ready_t &voiceEvent) {

            dpp::discord_voice_client *v = voiceEvent.voice_client;

            if(v && v->server_id == event.msg.guild_id && v->is_ready()) {
                promise.set_value(true);
            }
        });

        //Wait until bot joined voice channel
        std::future_status status;
        do
        {
            status = future.wait_for(std::chrono::milliseconds(500));
        } while (status != std::future_status::ready);

        //Remove event since it is not needed anymore
        bot.on_voice_ready.detach(eventId);
        return true;
}