#include "general.h"
#include <regex>

bool GeneralUtil::isUrl(std::string string)
{
    std::string urlPattern = "https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,4}\\b([-a-zA-Z0-9@:%_\\+.~#?&//=]*)";
    return std::regex_match(string, std::regex(urlPattern));
}

std::vector<std::string> GeneralUtil::explode(std::string const & s, char delim)
{
    std::vector<std::string> result;
    std::istringstream iss(s);

    for (std::string token; std::getline(iss, token, delim); )
    {
        result.push_back(std::move(token));
    }

    return result;
}