#include "queue.h"
#include <cstdlib>

QueueEntity::QueueEntity(dpp::snowflake guildId, std::string name) : guildId(guildId), name(name)
{
}

QueueEntity::QueueEntity(sqlite3_stmt *statement) : AbstractEntity(statement)
{
    guildId = std::strtol((char *)sqlite3_column_text(statement, 1), NULL, 0);
    name = std::string(reinterpret_cast<const char *>(sqlite3_column_text(statement, 2)));
    currentItemId = sqlite3_column_int(statement, 3);
}