#ifndef QUEUE_ITEM_ENTITY_H
#define QUEUE_ITEM_ENTITY_H

#include <string>

#include "abstract.h"

class QueueItemEntity : public AbstractEntity
{

public:
    using AbstractEntity::AbstractEntity;
    QueueItemEntity(sqlite3_stmt *statement);
    QueueItemEntity(int queueId, std::string source, std::string displayName, int position = -1, int duration = -1);
    int queueId;
    std::string source;
    std::string displayName;
    std::string type = "url";
    int position;
    int rowNumber;
    int duration = -1;
    std::string getDisplayName() const;
};

#endif