#include "shortcutremove.h"
#include "../utils/db.h"

std::vector<std::string> ShortcutRemoveCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-shortcutremove (.*?)$");
    regex.push_back("^-scr (.*?)$");
    return regex;
}

std::string ShortcutRemoveCommand::getHelp()
{
    return "**-shortcutremove [command|query], -scr [command|query]:** Removes a shortcut with the given command or query.";
}

void ShortcutRemoveCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    if (DbUtil::removeShortcutByCommandOrQuery(match1, event.msg.guild_id))
    {
        success(event, "Shortcut removed", "Shortcut **" + match1 + "** removed successfully.");
    }
    else
    {
        error(event, "Error removing shortcut");
    }
}
