#include "../entities/queue.h"
#include "../entities/queue-item.h"
#include "../utils/db.h"
#include "remove.h"

std::vector<std::string> RemoveCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-remove (\\d*)$");
    regex.push_back("^-r (\\d*)$");
    return regex;
}

bool RemoveCommand::userMustBeInBotsChannel()
{
    return true;
}

std::string RemoveCommand::getHelp()
{
    return "**-remove [position], -r [position]:** Removes the song with the given position from the queue. Positions can be retreived from the -queue command";
}

void RemoveCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    int position = std::stoi(match1);

    QueueEntity queue = DbUtil::getQueue(event.msg.guild_id);
    std::vector<QueueItemEntity> queueItems = DbUtil::getQueueItems(queue.id);

    if (position > queueItems.size())
    {
        error(event, "Queue item with position " + std::string(match1) + " not found.");
        return;
    }

    QueueItemEntity queueItem = queueItems[position - 1];
    if (DbUtil::removeQueueItem(queueItem) == 1)
    {
        //Successfully removed queue item from the database
        success(event, "", "Removed song " + queueItem.getDisplayName() + " from queue");
    }
    else
    {
        //Error removing the queue item from the database
        error(event, "", "Error removing " + queueItem.getDisplayName() + " from queue");
    }
}