#ifndef QUEUE_COMMAND_H
#define QUEUE_COMMAND_H

#include <dpp/dpp.h>
#include <string>

#include "abstract.h"

class QueueCommand : public AbstractCommand
{

public:
    using AbstractCommand::AbstractCommand;
    QueueCommand(dpp::cluster &bot);
    virtual std::vector<std::string> getRegex();
    virtual std::string getHelp();
    virtual void execute(dpp::message_create_t event, std::string match1, std::string match2);
    std::string intToTime(int duration);

private:
    dpp::component getComponents(std::vector<QueueItemEntity> queueItems, int offset, int countQueueItems);
    dpp::message buildMessage(dpp::event_dispatch_t event, dpp::snowflake guildId, dpp::snowflake channelId, QueueEntity queue, int offset = -1);
    bool replace(std::string &str, const std::string &from, const std::string &to);
};

#endif