#include "../entities/queue.h"
#include "../entities/queue-item.h"
#include "../utils/db.h"
#include "next.h"

NextCommand::NextCommand(dpp::cluster &bot, PlayCommand &playCommand, std::map<dpp::snowflake, std::shared_future<void>> &playCommandFutures) : AbstractCommand(bot), playCommand(playCommand), playCommandFutures(playCommandFutures)
{
}

bool NextCommand::userMustBeInBotsChannel()
{
    return true;
}

std::string NextCommand::getHelp()
{
    return "**-next, -n:** Skips to the next song";
}

std::vector<std::string> NextCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-next$");
    regex.push_back("^-n$");
    return regex;
}

void NextCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    //Get voice connection
    dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);
    if (!v || !v->voiceclient->is_ready())
    {
        error(event, "Currently not in voice channel");
        return;
    }

    QueueEntity queue = DbUtil::getQueue(event.msg.guild_id);
    if (queue.currentItemId == -1)
    {
        //No current item. It would need too many checks so that's why we just show an error message
        error(event, "No next queue item found");
        return;
    }

    QueueItemEntity currentQueueItem = DbUtil::getCurrentQueueItem(queue.currentItemId);
    if (currentQueueItem.id == -1)
    {
        error(event, "No next queue item found");
        return;
    }

    if (v->voiceclient->is_playing())
    {
        //Stop encoding of audio of currently playing song
        playCommand.guildIdAbortedEncodes[event.msg.guild_id] = true;
    }

    //Jump to queue item with specified position
    std::packaged_task<void()> packagedTask([this, v, event, currentQueueItem] {
        playCommand.playNext(v->voiceclient, event, currentQueueItem);
    });
    playCommandFutures[event.msg.guild_id] = packagedTask.get_future();

    std::thread thread(std::move(packagedTask));
    thread.detach();
}