#include "../entities/queue.h"
#include "../entities/queue-item.h"
#include "../utils/db.h"
#include "move.h"

std::vector<std::string> MoveCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-move (\\d*) (\\d*)$");
    regex.push_back("^-mv (\\d*) (\\d*)$");
    return regex;
}

bool MoveCommand::userMustBeInBotsChannel()
{
    return true;
}

std::string MoveCommand::getHelp()
{
    return "**-move [from] [to], -mv [from] [to]:** moves a song from position [from] to position [to]. Positions can be retreived from -queue command";
}

void MoveCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    int fromPosition = std::stoi(match1);
    int toPosition = std::stoi(match2);

    QueueEntity queue = DbUtil::getQueue(event.msg.guild_id);
    std::vector<QueueItemEntity> queueItems = DbUtil::getQueueItems(queue.id);

    if (fromPosition > queueItems.size())
    {
        error(event, "Queue item with position " + std::string(match1) + " not found.");
        return;
    }

    if (toPosition > queueItems.size())
    {
        error(event, "Queue item with position " + std::string(match2) + " not found.");
        return;
    }

    QueueItemEntity moveQueueItem = queueItems[fromPosition - 1];
    moveQueueItem.position = toPosition;

    //Move item in vector
    std::vector<QueueItemEntity> queueItemsToSave;
    for (int i = 0; i < queueItems.size(); i++)
    {
        if (queueItems[i].id == moveQueueItem.id)
        {
            //Skip adding queue item which should be moved because it would be at the wrong position
            continue;
        }

        if (i + 1 == toPosition)
        {
            queueItemsToSave.push_back(moveQueueItem);
        }

        queueItems[i].position = i + 1;
        queueItemsToSave.push_back(queueItems[i]);
    }

    //Save queue items to db
    DbUtil::saveQueueItems(queue.id, queueItemsToSave);

    success(event, "", "Moved song " + moveQueueItem.getDisplayName() + " from position " + std::string(match1) + " to " + std::string(match2));
}