#include "leave.h"

LeaveCommand::LeaveCommand(dpp::cluster &bot, PlayCommand &playCommand) : AbstractCommand(bot), playCommand(playCommand)
{
}

bool LeaveCommand::userMustBeInBotsChannel()
{
    return true;
}

std::vector<std::string> LeaveCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-leave$");
    regex.push_back("^-l$");
    return regex;
}

std::string LeaveCommand::getHelp()
{
    return "**-leave, -l:** Bot will leave the current voice channel (big sad or big bug)";
}

void LeaveCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    //Get voice connection
    dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);

    if (v && v->is_ready())
    {

        if (v->voiceclient && v->voiceclient->is_playing())
        {
            //Send signal to playCommand to flush
            playCommand.guildIdAbortedEncodes[event.msg.guild_id] = 2;
        }
        else
        {
            //Not playing --> directly leave voice channel
            event.from->disconnect_voice(event.msg.guild_id);
        }

        success(event, "Bye", "", "https://cdn.discordapp.com/attachments/880441252896718858/881941199420792852/hooray-its-weekend.png");
    }
    else
    {
        //Currently not in voice channel
        error(event, "Currently not in voice channel");
    }
}