#include "jump.h"
#include "../utils/db.h"

JumpCommand::JumpCommand(dpp::cluster &bot, PlayCommand &playCommand, std::map<dpp::snowflake, std::shared_future<void>> &playCommandFutures) : AbstractCommand(bot), playCommand(playCommand), playCommandFutures(playCommandFutures)
{
}

std::string JumpCommand::getHelp()
{
    return "**-jump [position], -j [position]:** Jumps to the song with the given position. Position can be retreived from -queue command";
}

std::vector<std::string> JumpCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-jump (\\d*)$");
    regex.push_back("^-j (\\d*)$");
    return regex;
}

void JumpCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    int position = std::stoi(match1);

    QueueEntity queue = DbUtil::getQueue(event.msg.guild_id);
    std::vector<QueueItemEntity> queueItems = DbUtil::getQueueItems(queue.id);

    if (position > queueItems.size())
    {
        error(event, "Queue item with position " + std::string(match1) + " not found.");
        return;
    }

    //Get voice connection
    dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);
    if (!v || !v->voiceclient->is_ready())
    {
        //Join voice channel
        dpp::guild *g = dpp::find_guild(event.msg.guild_id);
        if (!g->connect_member_voice(event.msg.author.id, false, true))
        {
            error(event, "You don't seem to be in a voice channel! :(");
            return;
        }

        //Register on_voice_ready event to then directly play audio after joining the voice channel
        std::promise<bool> promise;
        std::shared_future<bool> future = promise.get_future();
        dpp::event_handle eventId = bot.on_voice_ready([&promise, event](const dpp::voice_ready_t &voiceEvent) {

            dpp::discord_voice_client *v = voiceEvent.voice_client;

            if(v && v->server_id == event.msg.guild_id && v->is_ready()) {
                promise.set_value(true);
            }
        });

        //Wait until bot joined voice channel
        std::future_status status;
        do
        {
            status = future.wait_for(std::chrono::milliseconds(500));
        } while (status != std::future_status::ready);

        //Remove event since it is not needed anymore
        bot.on_voice_ready.detach(eventId);
    }

    v = event.from->get_voice(event.msg.guild_id);
    if (v->voiceclient->is_playing())
    {
        //Stop encoding of audio of currently playing song
        playCommand.guildIdAbortedEncodes[event.msg.guild_id] = true;
    }
    
    //Jump to queue item with specified position
    QueueItemEntity queueItem = queueItems[position - 1];

    jumpToQueueItem(event, queueItem);
}

void JumpCommand::jumpToQueueItem(dpp::message_create_t event, QueueItemEntity &queueItemEntity)
{
    dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);
    std::packaged_task<void()> packagedTask([this, v, event, queueItemEntity] {
        playCommand.play(v->voiceclient, event, queueItemEntity);
    });
    playCommandFutures[event.msg.guild_id] = packagedTask.get_future();

    std::thread thread(std::move(packagedTask));
    thread.detach();
}