#include "abstract.h"

AbstractCommand::AbstractCommand(dpp::cluster &bot) : bot(bot)
{
}

bool AbstractCommand::userMustBeInBotsChannel()
{
    return false;
}

void AbstractCommand::success(dpp::message_create_t event, std::string title, std::string description, std::string mediaUri)
{
    sendEmbed(0x00ff00, event, title, description, mediaUri);
}

void AbstractCommand::error(dpp::message_create_t event, std::string title, std::string description, std::string mediaUri)
{
    sendEmbed(0xff0000, event, title, description, mediaUri);
}

void AbstractCommand::sendEmbed(uint32_t color, dpp::message_create_t event, std::string title, std::string description, std::string mediaUri)
{
    dpp::embed embed = createEmbed(color, title, description, mediaUri);

    //Reply with the created embed
    bot.message_create(dpp::message(event.msg.channel_id, embed));
}

dpp::embed AbstractCommand::createEmbed(uint32_t color, std::string title, std::string description, std::string mediaUri)
{
    dpp::embed embed = dpp::embed().set_color(color).set_title(title);

    if (description != std::string())
    {
        embed.set_description(description);
    }

    if (mediaUri != std::string())
    {
        embed.set_image(mediaUri);
    }

    return embed;
}