# musigloutr++

Discord music bot which plays everything [yt-dlp](https://github.com/yt-dlp/yt-dlp) can handle (e.g. Youtube, HTTP streams) and Spotify (open.spotify.com links which you can get with right-click > Share > Copy Song Link).

## Requirements

Currently only Linux systems are supported.
The bot is currently being tested on Debian trixie, sid and Ubuntu noble.

These are the required libraries:

- [GIT](https://git-scm.com/)

- [SQLite](https://www.sqlite.org) database

- libsqlite3 (whichever -dev package comes with your OS)

- [spotify_dl](https://github.com/SathyaBhat/spotify-dl)

- [yt-dlp](https://github.com/yt-dlp/yt-dlp) (included with spotify_dl, no need to install it separately)

- [OpenSSL](https://openssl.org/) (whichever -dev package comes with your OS)

- [zlib](https://zlib.net/) (whichever -dev package comes with your OS)

- [LibOpus](https://www.opus-codec.org/)

- [libsodium](https://github.com/jedisct1/libsodium)

- [FFmpeg](https://ffmpeg.org/) >= 2.0

  - libavformat >= 54.x.x

  - libavcodec >= 54.x.x

  - libavfilter >= 3.x.x

  - libavutil >= 51.x.x

  - libswscale >= 2.x.x

  - libswresample >= 0.x.x

  - libpostproc >= 52.x.x

## Discord bot setup

- Visit the [Discord developer portal](https://discord.com/developers/applications)

- Create a new application

- Navigate to "Bot" on the left side and add a new bot

- Copy the bot token

- In the bots settings: activate the "Message Content Intent" setting

## Adding the bot to your server

- Copy the "Application ID" from the "General Information" tab on the Discord developer portal

- Open the following url in your browser and follow the steps: <https://discord.com/api/oauth2/authorize?client_id>=``APPLICATION_ID``&permissions=2184313920&scope=bot%20applications.commands

## Installation

- Install all required libraries
  - Debian:
  ```shell
    sudo apt-get update
    sudo apt-get install -y git g++ cmake make sqlite3 libsqlite3-dev python3 python3-pip ffmpeg libopus-dev libsodium-dev libzstd-dev zlib1g-dev libssl-dev pkg-config libavcodec-dev libavformat-dev libavdevice-dev catch2 libogg-dev libopusfile-dev
    pip3 install spotify_dl
    ```
  - Gentoo:
  ```shell
    sudo emaint sync
    sudo emerge --ask dev-vcs/git sys-devel/gcc dev-build/cmake dev-build/make dev-ruby/sqlite3 =dev-lang/python-3.12.7_p1 dev-python/pip media-video/ffmpeg media-libs/opusfile dev-libs/libsodium sys-libs/zlib dev-libs/openssl dev-cpp/catch media-libs/libogg media-libs/opus
    pip3 install spotify_dl
    ```

- Clone this repository

- Create an application and copy the client id and secret from the [Spotify developer console](https://developer.spotify.com)

- Create an API client and click on the "Generate Access Token" button on the [Genius API clients page](https://genius.com/api-clients). Copy the generated token.

- Create a config file ``~/.local/share/musigloutr/config.json`` with the following content

  - ```json
    {
        "bot_token": "BOT_TOKEN",
        "spotify_client_id": "SPOTIFY_CLIENT_ID",
        "spotify_client_secret": "SPOTIFY_CLIENT_SECRET",
        "sqlite_path": "PATH_TO_SQLITE_FILE",
        "genius_access_token": "GENIUS_ACCESS_TOKEN"
    }
    ```
  - The file specified as ``sqlite_path`` will be automatically created once the bot starts up

- In the root directory of the repository run

  - ```shell
    cmake -S . -B build
    make -C build
    ```
  - To build the bot with static DPP, AvCpp and cpr dependencies run

    ```shell
    cmake -S . -B build -DMLPP_STATIC_LIBS=ON
    make -C build
    ```

- To run the bot execute ``build/musigloutr++``

## Systemd setup

- Copy the [musigloutr-plus-plus.service](musigloutr-plus-plus.service) file to ``~/.config/systemd/user/``. The config file assumes that this repository has been cloned to ``~/musigloutr++``

- Run ``systemctl --user daemon-reload``

- Run ``systemctl --user enable --now musigloutr-plus-plus.service``

## Credits

- [DPP](https://github.com/brainboxdotcc/DPP)

- [AvCpp](https://github.com/h4tr3d/avcpp)

- [yt-dlp](https://github.com/yt-dlp/yt-dlp)

- [spotify_dl](https://github.com/SathyaBhat/spotify-dl)

- [cpr](https://github.com/libcpr/cpr)
